/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.admin.property.region;

import filenet.vw.api.VWSystemConfiguration;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.admin.resources.VWResource;
import filenet.vw.toolkit.utils.VWAccessibilityHelper;
import filenet.vw.toolkit.utils.VWKeyAdapter;
import filenet.vw.toolkit.utils.uicontrols.border.VWTitledBorder;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class VWConfigLogOptionPane
extends JPanel {
    private static final int TOP_MARGIN = 1;
    private static final int BOTTOM_MARGIN = 1;
    private static final int LEFT_MARGIN = 4;
    private static final int RIGHT_MARGIN = 40;
    protected JCheckBox m_systemMessageCheckBox = null;
    protected JCheckBox m_woEmptyStepCheckBox = null;
    protected JCheckBox m_woRulesCheckBox = null;
    protected JCheckBox m_woMilestonesCheckBox = null;
    protected JCheckBox m_woTraceInstructionCheckBox = null;
    protected JCheckBox m_woCreationCheckBox = null;
    protected JCheckBox m_woTerminationCheckBox = null;
    protected JCheckBox m_woExceptionCheckBox = null;
    protected JCheckBox m_woAdminMessageCheckBox = null;
    protected JCheckBox m_woBeginOperationCheckBox = null;
    protected JCheckBox m_woEndOperationCheckBox = null;
    protected JCheckBox m_userMsg1CheckBox = null;
    protected JCheckBox m_userMsg2CheckBox = null;
    protected VWSystemConfiguration m_sysConfig = null;
    protected int m_nLogState = -1;
    protected boolean m_bDirty = false;

    public VWConfigLogOptionPane(VWSystemConfiguration sysConfig) {
        try {
            this.m_sysConfig = sysConfig;
            this.m_nLogState = this.m_sysConfig.getLoggingState();
            this.setLayout(new GridBagLayout());
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.fill = 2;
            gbCons.weightx = 1.0;
            gbCons.weighty = 0.0;
            gbCons.anchor = 23;
            gbCons.gridwidth = 1;
            gbCons.gridheight = 1;
            gbCons.insets = new Insets(5, 5, 5, 5);
            this.add((Component)this.createSystemMsgPanel(), gbCons);
            ++gbCons.gridy;
            this.add((Component)this.createTopPanel(), gbCons);
            ++gbCons.gridy;
            this.add((Component)this.createUserMsgPanel(), gbCons);
            ++gbCons.gridy;
            gbCons.fill = 1;
            gbCons.weightx = 1.0;
            gbCons.weighty = 1.0;
            this.add((Component)new JLabel(" "), gbCons);
            this.initializeControls();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void update() {
        try {
            this.checkIsDirty();
            this.m_sysConfig.setLoggingState(16, this.m_woEmptyStepCheckBox.isSelected());
            this.m_sysConfig.setLoggingState(32, this.m_woRulesCheckBox.isSelected());
            this.m_sysConfig.setLoggingState(64, this.m_woMilestonesCheckBox.isSelected());
            this.m_sysConfig.setLoggingState(128, this.m_woTraceInstructionCheckBox.isSelected());
            this.m_sysConfig.setLoggingState(256, this.m_woCreationCheckBox.isSelected());
            this.m_sysConfig.setLoggingState(512, this.m_woTerminationCheckBox.isSelected());
            this.m_sysConfig.setLoggingState(1024, this.m_woExceptionCheckBox.isSelected());
            this.m_sysConfig.setLoggingState(4096, this.m_woAdminMessageCheckBox.isSelected());
            this.m_sysConfig.setLoggingState(65536, this.m_systemMessageCheckBox.isSelected());
            this.m_sysConfig.setLoggingState(0x100000, this.m_woBeginOperationCheckBox.isSelected());
            this.m_sysConfig.setLoggingState(0x400000, this.m_woEndOperationCheckBox.isSelected());
            this.m_sysConfig.setLoggingState(0x40000000, this.m_userMsg1CheckBox.isSelected());
            this.m_sysConfig.setLoggingState(Integer.MIN_VALUE, this.m_userMsg2CheckBox.isSelected());
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void releaseResources() {
        if (this.m_systemMessageCheckBox != null) {
            this.m_systemMessageCheckBox.removeAll();
            this.m_systemMessageCheckBox = null;
        }
        if (this.m_woEmptyStepCheckBox != null) {
            this.m_woEmptyStepCheckBox.removeAll();
            this.m_woEmptyStepCheckBox = null;
        }
        if (this.m_woRulesCheckBox != null) {
            this.m_woRulesCheckBox.removeAll();
            this.m_woRulesCheckBox = null;
        }
        if (this.m_woMilestonesCheckBox != null) {
            this.m_woMilestonesCheckBox.removeAll();
            this.m_woMilestonesCheckBox = null;
        }
        if (this.m_woTraceInstructionCheckBox != null) {
            this.m_woTraceInstructionCheckBox.removeAll();
            this.m_woTraceInstructionCheckBox = null;
        }
        if (this.m_woCreationCheckBox != null) {
            this.m_woCreationCheckBox.removeAll();
            this.m_woCreationCheckBox = null;
        }
        if (this.m_woTerminationCheckBox != null) {
            this.m_woTerminationCheckBox.removeAll();
            this.m_woTerminationCheckBox = null;
        }
        if (this.m_woExceptionCheckBox != null) {
            this.m_woExceptionCheckBox.removeAll();
            this.m_woExceptionCheckBox = null;
        }
        if (this.m_woAdminMessageCheckBox != null) {
            this.m_woAdminMessageCheckBox.removeAll();
            this.m_woAdminMessageCheckBox = null;
        }
        if (this.m_woBeginOperationCheckBox != null) {
            this.m_woBeginOperationCheckBox.removeAll();
            this.m_woBeginOperationCheckBox = null;
        }
        if (this.m_woEndOperationCheckBox != null) {
            this.m_woEndOperationCheckBox.removeAll();
            this.m_woEndOperationCheckBox = null;
        }
        if (this.m_userMsg1CheckBox != null) {
            this.m_userMsg1CheckBox.removeAll();
            this.m_userMsg1CheckBox = null;
        }
        if (this.m_userMsg2CheckBox != null) {
            this.m_userMsg2CheckBox.removeAll();
            this.m_userMsg2CheckBox = null;
        }
        this.m_sysConfig = null;
        this.removeAll();
    }

    protected JPanel createSystemMsgPanel() {
        try {
            JPanel childPanel = new JPanel();
            childPanel.setBorder(new VWTitledBorder(VWResource.SystemMessagesTitle));
            childPanel.setLayout(new GridBagLayout());
            childPanel.addKeyListener(VWKeyAdapter.s_keyAdapter);
            String title = VWResource.SystemMessagesTitle + " ";
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.fill = 2;
            gbCons.weightx = 0.5;
            gbCons.weighty = 0.0;
            gbCons.anchor = 23;
            gbCons.gridwidth = 1;
            gbCons.gridheight = 1;
            gbCons.insets = new Insets(1, 4, 1, 40);
            this.m_systemMessageCheckBox = new JCheckBox(VWResource.SystemMessageLabel);
            VWAccessibilityHelper.setAccessibility(this.m_systemMessageCheckBox, this, title + VWResource.SystemMessageLabel, title + VWResource.SystemMessageLabel);
            this.m_systemMessageCheckBox.addKeyListener(VWKeyAdapter.s_keyAdapter);
            childPanel.add((Component)this.m_systemMessageCheckBox, gbCons);
            return childPanel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    protected JPanel createTopPanel() {
        try {
            JPanel childPanel = new JPanel();
            childPanel.setBorder(new VWTitledBorder(VWResource.WorkItemMessagesTitle));
            childPanel.addKeyListener(VWKeyAdapter.s_keyAdapter);
            String title = VWResource.WorkItemMessagesTitle + " ";
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.fill = 2;
            gbCons.weightx = 0.5;
            gbCons.weighty = 0.0;
            gbCons.anchor = 23;
            gbCons.gridwidth = 1;
            gbCons.gridheight = 1;
            gbCons.insets = new Insets(1, 4, 1, 40);
            JPanel upperLeftPanel = new JPanel();
            upperLeftPanel.setLayout(new GridBagLayout());
            this.m_woEmptyStepCheckBox = new JCheckBox(VWResource.EmptyStepCompletion);
            VWAccessibilityHelper.setAccessibility(this.m_woEmptyStepCheckBox, this, title + VWResource.EmptyStepCompletion, title + VWResource.EmptyStepCompletion);
            this.m_woEmptyStepCheckBox.addKeyListener(VWKeyAdapter.s_keyAdapter);
            upperLeftPanel.add((Component)this.m_woEmptyStepCheckBox, gbCons);
            ++gbCons.gridy;
            this.m_woRulesCheckBox = new JCheckBox(VWResource.Rules);
            VWAccessibilityHelper.setAccessibility(this.m_woRulesCheckBox, this, title + VWResource.Rules, title + VWResource.Rules);
            this.m_woRulesCheckBox.addKeyListener(VWKeyAdapter.s_keyAdapter);
            upperLeftPanel.add((Component)this.m_woRulesCheckBox, gbCons);
            ++gbCons.gridy;
            this.m_woMilestonesCheckBox = new JCheckBox(VWResource.Milestones);
            VWAccessibilityHelper.setAccessibility(this.m_woMilestonesCheckBox, this, title + VWResource.Milestones, title + VWResource.Milestones);
            this.m_woMilestonesCheckBox.addKeyListener(VWKeyAdapter.s_keyAdapter);
            upperLeftPanel.add((Component)this.m_woMilestonesCheckBox, gbCons);
            JPanel lowerLeftPanel = new JPanel();
            lowerLeftPanel.setLayout(new GridBagLayout());
            gbCons.gridy = 0;
            this.m_woTraceInstructionCheckBox = new JCheckBox(VWResource.TraceInstruction);
            VWAccessibilityHelper.setAccessibility(this.m_woTraceInstructionCheckBox, this, title + VWResource.TraceInstruction, title + VWResource.TraceInstruction);
            this.m_woMilestonesCheckBox.addKeyListener(VWKeyAdapter.s_keyAdapter);
            lowerLeftPanel.add((Component)this.m_woTraceInstructionCheckBox, gbCons);
            ++gbCons.gridy;
            this.m_woCreationCheckBox = new JCheckBox(VWResource.Creation);
            VWAccessibilityHelper.setAccessibility(this.m_woCreationCheckBox, this, title + VWResource.Creation, title + VWResource.Creation);
            this.m_woCreationCheckBox.addKeyListener(VWKeyAdapter.s_keyAdapter);
            lowerLeftPanel.add((Component)this.m_woCreationCheckBox, gbCons);
            JPanel leftPanel = new JPanel();
            leftPanel.setLayout(new BoxLayout(leftPanel, 3));
            leftPanel.add(upperLeftPanel);
            leftPanel.add(lowerLeftPanel);
            GridBagConstraints gbCons2 = new GridBagConstraints();
            gbCons2.gridx = 0;
            gbCons2.gridy = 0;
            gbCons2.fill = 2;
            gbCons2.weightx = 0.5;
            gbCons2.weighty = 0.0;
            gbCons2.anchor = 23;
            gbCons2.gridwidth = 1;
            gbCons2.gridheight = 1;
            gbCons2.insets = new Insets(1, 4, 1, 40);
            JPanel upperRightPanel = new JPanel();
            upperRightPanel.setLayout(new GridBagLayout());
            gbCons2.gridx = 0;
            gbCons2.gridy = 0;
            gbCons2.gridwidth = 1;
            this.m_woTerminationCheckBox = new JCheckBox(VWResource.Termination);
            VWAccessibilityHelper.setAccessibility(this.m_woTerminationCheckBox, this, title + VWResource.Termination, title + VWResource.Termination);
            this.m_woTerminationCheckBox.addKeyListener(VWKeyAdapter.s_keyAdapter);
            upperRightPanel.add((Component)this.m_woTerminationCheckBox, gbCons2);
            ++gbCons2.gridy;
            this.m_woExceptionCheckBox = new JCheckBox(VWResource.ExceptionLabel);
            VWAccessibilityHelper.setAccessibility(this.m_woExceptionCheckBox, this, title + VWResource.ExceptionLabel, title + VWResource.ExceptionLabel);
            this.m_woExceptionCheckBox.addKeyListener(VWKeyAdapter.s_keyAdapter);
            upperRightPanel.add((Component)this.m_woExceptionCheckBox, gbCons2);
            ++gbCons2.gridy;
            this.m_woAdminMessageCheckBox = new JCheckBox(VWResource.AdminMessage);
            VWAccessibilityHelper.setAccessibility(this.m_woAdminMessageCheckBox, this, title + VWResource.AdminMessage, title + VWResource.AdminMessage);
            this.m_woAdminMessageCheckBox.addKeyListener(VWKeyAdapter.s_keyAdapter);
            upperRightPanel.add((Component)this.m_woAdminMessageCheckBox, gbCons2);
            JPanel lowerRightPanel = new JPanel();
            lowerRightPanel.setLayout(new GridBagLayout());
            gbCons2.gridy = 0;
            this.m_woBeginOperationCheckBox = new JCheckBox(VWResource.BeginOperation);
            VWAccessibilityHelper.setAccessibility(this.m_woBeginOperationCheckBox, this, title + VWResource.BeginOperation, title + VWResource.BeginOperation);
            this.m_woBeginOperationCheckBox.addKeyListener(VWKeyAdapter.s_keyAdapter);
            lowerRightPanel.add((Component)this.m_woBeginOperationCheckBox, gbCons2);
            ++gbCons2.gridy;
            this.m_woEndOperationCheckBox = new JCheckBox(VWResource.EndOperation);
            VWAccessibilityHelper.setAccessibility(this.m_woEndOperationCheckBox, this, title + VWResource.EndOperation, title + VWResource.EndOperation);
            this.m_woEndOperationCheckBox.addKeyListener(VWKeyAdapter.s_keyAdapter);
            lowerRightPanel.add((Component)this.m_woEndOperationCheckBox, gbCons2);
            JPanel rightPanel = new JPanel();
            rightPanel.setLayout(new BoxLayout(rightPanel, 3));
            rightPanel.add(upperRightPanel);
            rightPanel.add(lowerRightPanel);
            childPanel.setLayout(new BoxLayout(childPanel, 2));
            childPanel.add(leftPanel);
            childPanel.add(rightPanel);
            return childPanel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    protected JPanel createUserMsgPanel() {
        try {
            JPanel childPanel = new JPanel();
            childPanel.setBorder(new VWTitledBorder(VWResource.UserDefinedMessagesTitle));
            childPanel.setLayout(new GridBagLayout());
            childPanel.addKeyListener(VWKeyAdapter.s_keyAdapter);
            String title = VWResource.UserDefinedMessagesTitle;
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.fill = 2;
            gbCons.weightx = 0.5;
            gbCons.weighty = 0.0;
            gbCons.anchor = 23;
            gbCons.gridwidth = 1;
            gbCons.gridheight = 1;
            gbCons.insets = new Insets(1, 4, 1, 40);
            this.m_userMsg1CheckBox = new JCheckBox(VWResource.UserDefinedMessages1);
            VWAccessibilityHelper.setAccessibility(this.m_userMsg1CheckBox, this, title + VWResource.UserDefinedMessages1, title + VWResource.UserDefinedMessages1);
            this.m_userMsg1CheckBox.addKeyListener(VWKeyAdapter.s_keyAdapter);
            childPanel.add((Component)this.m_userMsg1CheckBox, gbCons);
            gbCons.gridx = 1;
            gbCons.gridy = 0;
            gbCons.gridwidth = 0;
            this.m_userMsg2CheckBox = new JCheckBox(VWResource.UserDefinedMessages2);
            VWAccessibilityHelper.setAccessibility(this.m_userMsg2CheckBox, this, title + VWResource.UserDefinedMessages2, title + VWResource.UserDefinedMessages2);
            this.m_userMsg2CheckBox.addKeyListener(VWKeyAdapter.s_keyAdapter);
            childPanel.add((Component)this.m_userMsg2CheckBox, gbCons);
            return childPanel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    protected void initializeControls() {
        try {
            this.m_systemMessageCheckBox.setSelected(this.isFlagSelected(65536));
            this.m_woEmptyStepCheckBox.setSelected(this.isFlagSelected(16));
            this.m_woRulesCheckBox.setSelected(this.isFlagSelected(32));
            this.m_woMilestonesCheckBox.setSelected(this.isFlagSelected(64));
            this.m_woTraceInstructionCheckBox.setSelected(this.isFlagSelected(128));
            this.m_woCreationCheckBox.setSelected(this.isFlagSelected(256));
            this.m_woTerminationCheckBox.setSelected(this.isFlagSelected(512));
            this.m_woExceptionCheckBox.setSelected(this.isFlagSelected(1024));
            this.m_woAdminMessageCheckBox.setSelected(this.isFlagSelected(4096));
            this.m_woBeginOperationCheckBox.setSelected(this.isFlagSelected(0x100000));
            this.m_woEndOperationCheckBox.setSelected(this.isFlagSelected(0x400000));
            this.m_userMsg1CheckBox.setSelected(this.isFlagSelected(0x40000000));
            this.m_userMsg2CheckBox.setSelected(this.isFlagSelected(Integer.MIN_VALUE));
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected void checkIsDirty() {
        try {
            if (this.isFlagSelected(65536) != this.m_systemMessageCheckBox.isSelected()) {
                this.m_bDirty = true;
                return;
            }
            if (this.isFlagSelected(16) != this.m_woEmptyStepCheckBox.isSelected()) {
                this.m_bDirty = true;
                return;
            }
            if (this.isFlagSelected(32) != this.m_woRulesCheckBox.isSelected()) {
                this.m_bDirty = true;
                return;
            }
            if (this.isFlagSelected(64) != this.m_woMilestonesCheckBox.isSelected()) {
                this.m_bDirty = true;
                return;
            }
            if (this.isFlagSelected(128) != this.m_woTraceInstructionCheckBox.isSelected()) {
                this.m_bDirty = true;
                return;
            }
            if (this.isFlagSelected(256) != this.m_woCreationCheckBox.isSelected()) {
                this.m_bDirty = true;
                return;
            }
            if (this.isFlagSelected(512) != this.m_woTerminationCheckBox.isSelected()) {
                this.m_bDirty = true;
                return;
            }
            if (this.isFlagSelected(1024) != this.m_woExceptionCheckBox.isSelected()) {
                this.m_bDirty = true;
                return;
            }
            if (this.isFlagSelected(4096) != this.m_woAdminMessageCheckBox.isSelected()) {
                this.m_bDirty = true;
                return;
            }
            if (this.isFlagSelected(0x100000) != this.m_woBeginOperationCheckBox.isSelected()) {
                this.m_bDirty = true;
                return;
            }
            if (this.isFlagSelected(0x400000) != this.m_woEndOperationCheckBox.isSelected()) {
                this.m_bDirty = true;
                return;
            }
            if (this.isFlagSelected(0x40000000) != this.m_userMsg1CheckBox.isSelected()) {
                this.m_bDirty = true;
                return;
            }
            if (this.isFlagSelected(Integer.MIN_VALUE) != this.m_userMsg2CheckBox.isSelected()) {
                this.m_bDirty = true;
                return;
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected boolean isFlagSelected(int nFlag) {
        return (this.m_nLogState & nFlag) == nFlag;
    }
}

